using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace PDFCreatorApp
{
	/// <summary>
	/// Summary description for PageFormatForm.
	/// </summary>
	public class PageFormatForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.CheckBox checkBoxLandscape;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox txtCopies;
		private System.Windows.Forms.TextBox txtDuplex;
		private System.Windows.Forms.TextBox txtWidth;
		private System.Windows.Forms.TextBox txtLength;
		private System.Windows.Forms.TextBox txtPaperBin;
		private System.Windows.Forms.Button button1;
		private Amyuni.PDFCreator.IacPageFormat m_format = null;
		private System.Windows.Forms.Button button2;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public PageFormatForm(Amyuni.PDFCreator.IacPageFormat format)
		{
			this.m_format = format;

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.txtCopies.Text = format.Copies.ToString();
			this.txtDuplex.Text = format.Duplex.ToString();
			this.txtWidth.Text = format.Width.ToString();
			this.txtLength.Text = format.Length.ToString();
			this.checkBoxLandscape.Checked = format.Landscape;
			this.txtPaperBin.Text = format.PaperBin.ToString();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.checkBoxLandscape = new System.Windows.Forms.CheckBox();
			this.label6 = new System.Windows.Forms.Label();
			this.txtCopies = new System.Windows.Forms.TextBox();
			this.txtDuplex = new System.Windows.Forms.TextBox();
			this.txtWidth = new System.Windows.Forms.TextBox();
			this.txtLength = new System.Windows.Forms.TextBox();
			this.txtPaperBin = new System.Windows.Forms.TextBox();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(32, 48);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(128, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "Copies:";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(32, 81);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(128, 24);
			this.label2.TabIndex = 1;
			this.label2.Text = "Duplex:";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(32, 114);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(128, 24);
			this.label3.TabIndex = 2;
			this.label3.Text = "Width:";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(32, 147);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(128, 24);
			this.label4.TabIndex = 3;
			this.label4.Text = "Length:";
			// 
			// checkBoxLandscape
			// 
			this.checkBoxLandscape.Location = new System.Drawing.Point(32, 180);
			this.checkBoxLandscape.Name = "checkBoxLandscape";
			this.checkBoxLandscape.Size = new System.Drawing.Size(136, 24);
			this.checkBoxLandscape.TabIndex = 4;
			this.checkBoxLandscape.Text = "Landscape";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(32, 213);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(128, 24);
			this.label6.TabIndex = 5;
			this.label6.Text = "Paper Bin:";
			// 
			// txtCopies
			// 
			this.txtCopies.Location = new System.Drawing.Point(176, 48);
			this.txtCopies.Name = "txtCopies";
			this.txtCopies.Size = new System.Drawing.Size(136, 20);
			this.txtCopies.TabIndex = 6;
			this.txtCopies.Text = "";
			// 
			// txtDuplex
			// 
			this.txtDuplex.Location = new System.Drawing.Point(176, 82);
			this.txtDuplex.Name = "txtDuplex";
			this.txtDuplex.Size = new System.Drawing.Size(136, 20);
			this.txtDuplex.TabIndex = 7;
			this.txtDuplex.Text = "";
			// 
			// txtWidth
			// 
			this.txtWidth.Location = new System.Drawing.Point(176, 116);
			this.txtWidth.Name = "txtWidth";
			this.txtWidth.Size = new System.Drawing.Size(136, 20);
			this.txtWidth.TabIndex = 8;
			this.txtWidth.Text = "";
			// 
			// txtLength
			// 
			this.txtLength.Location = new System.Drawing.Point(176, 150);
			this.txtLength.Name = "txtLength";
			this.txtLength.Size = new System.Drawing.Size(136, 20);
			this.txtLength.TabIndex = 9;
			this.txtLength.Text = "";
			// 
			// txtPaperBin
			// 
			this.txtPaperBin.Location = new System.Drawing.Point(176, 208);
			this.txtPaperBin.Name = "txtPaperBin";
			this.txtPaperBin.Size = new System.Drawing.Size(136, 20);
			this.txtPaperBin.TabIndex = 10;
			this.txtPaperBin.Text = "";
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(104, 248);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(80, 24);
			this.button1.TabIndex = 11;
			this.button1.Text = "Ok";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(216, 248);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(88, 24);
			this.button2.TabIndex = 12;
			this.button2.Text = "Cancel";
			// 
			// PageFormatForm
			// 
			this.AcceptButton = this.button1;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.button2;
			this.ClientSize = new System.Drawing.Size(408, 302);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.txtPaperBin);
			this.Controls.Add(this.txtLength);
			this.Controls.Add(this.txtWidth);
			this.Controls.Add(this.txtDuplex);
			this.Controls.Add(this.txtCopies);
			this.Controls.Add(this.checkBoxLandscape);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.label6);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "PageFormatForm";
			this.Text = "Page Format";
			this.ResumeLayout(false);

		}
		#endregion

		private void button1_Click(object sender, System.EventArgs e)
		{
			try
			{

				m_format.Copies = Convert.ToUInt32(txtCopies.Text);
				m_format.Duplex = Convert.ToInt32(txtDuplex.Text);
				m_format.Width  = Convert.ToInt32(txtWidth.Text);
				m_format.Length  = Convert.ToInt32(txtLength.Text);
				m_format.Landscape = this.checkBoxLandscape.Checked;
				m_format.PaperBin = Convert.ToInt32(txtPaperBin.Text);
			} 
			catch(System.Exception )
			{
				MessageBox.Show("The values specified are not valid. Please enter new values or Cancel.");
				return;
			}

			this.Close();
		}
	}
}
